#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/ccm/header.h"
extern u8 _ccm_segment_ESegmentRomStart[];
extern u8 _ccm_segment_ESegmentRomEnd[];

const LevelScript level_ccm_entry[] = {
INIT_LEVEL(),
LOAD_RAW(0x0E, _ccm_segment_ESegmentRomStart, _ccm_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _ccm_skybox_mio0SegmentRomStart, _ccm_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group1_mio0SegmentRomStart, _group1_mio0SegmentRomEnd),
LOAD_RAW(12, _group1_geoSegmentRomStart, _group1_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_2),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_ccm_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_ccm_1_[] = {
AREA(1, Geo_ccm_1_0x140ef90),
TERRAIN(col_ccm_1_0xe017630),
SET_BACKGROUND_MUSIC(0, 51),
TERRAIN_TYPE(2),
JUMP_LINK(local_objects_ccm_1_),
JUMP_LINK(local_warps_ccm_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_ccm_1_[] = {
OBJECT_WITH_ACTS(0, 1536, 2484, -1423, 0, 120, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 14601, 6455, -566, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 5693, 8400, -8095, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 12793, 8340, -8732, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 1569, 5841, -1448, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 13804, 4320, -5986, 0, 0, 0, 0xd0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 12615, 3795, -2948, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, 11985, 3960, -1428, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 9149, 4740, -2875, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 12415, 8474, -11164, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 14257, 8490, -11280, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4003, 4260, -12326, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 12947, 6240, -178, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4926, 1590, -746, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2024, 2610, -1722, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, 4583, 1697, -774, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 785, 1717, -4147, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(223, 8543, 5025, -690, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 1559, 2430, -650, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 3313, 2650, -4257, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 10703, 3630, -7780, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 9140, 5524, -4082, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 895, 7865, -8296, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2916, 5775, -11519, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 1742, 2400, -6285, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 5934, 2400, -3071, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 11986, 3275, -4111, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 9146, 4730, -9789, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(25, 3654, 2775, -6393, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 4931, 3025, -6554, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 6209, 3275, -6360, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 4025, 5775, -10725, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 10727, 4525, -8618, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(206, 8190, 4230, -1732, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(206, 3387, 9309, -8971, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(206, 13263, 6870, -9879, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(180, 10190, 6210, -432, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 4929, 3930, -11740, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 1070, 6600, -11748, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 10186, 6240, -12217, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 14403, 7020, -8728, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(89, 853, 6775, -10889, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(89, 665, 7275, -9826, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(223, 6382, 1900, -1296, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 13531, 6400, -8710, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(101, 6172, 3275, -9598, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(223, 11762, 6400, -9857, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 14940, 3650, -5759, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 11771, 6750, -7991, 0, 0, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 14859, 6990, -12350, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 1399, 3030, -7409, 0, 0, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(188, 9854, 4525, -8276, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(89, 13308, 6400, -11317, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(101, 12791, 3650, -5846, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(188, 1949, 5775, -12071, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(25, 11122, 6400, -12127, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 8116, 3275, -4191, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 12513, 3275, -719, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(101, 8917, 4775, -11256, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(192, 6741, 3275, -8509, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(137, 7868, 5310, -251, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 14961, 6400, -7867, 0, 270, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 7348, 5250, -12334, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(206, 1511, 6540, -11376, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(0, 9873, 3275, -1963, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(124, 8194, 4775, -11950, 0, 90, 0, 0x240000,  bhvMessagePanel, 31),
RETURN()
};

const LevelScript local_warps_ccm_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 1, 44, 0),
WARP_NODE(241, 6, 1, 54, 0),
RETURN()
};
